# Q4 — Entanglement under a gravitational (boolean) gradient (CHSH)

This repository reproduces **Stage Q4** of the V2 simulations: a local, boolean ParentGate on the **left** wing suppresses tie feasibility at the measurement hinge and degrades CHSH correlations from the quantum value toward 0 while preserving **no-signalling**.

## How to run

```bash
python -m venv .venv && . .venv/bin/activate
pip install -r requirements.txt
python run_q4.py --mode tsirelson --K 300000 --seeds 101 202 303 --g 0.0 0.2 0.4 0.6 0.8
```

Outputs will be written to `data/`:

- `q4_chsh_summary.csv` — per *g*: `g,left_pass_rate,E00,E01,E10,E11,S,SE_S,trials_per_pair`
- `q4_chsh_marginals.csv` — per *(g,a,b)*: `g,a,b,P_A_plus,P_B_plus,trials`
- `q4_chsh_ties.csv` — per *g*: `g,left_pass_rate`
- `q4_manifest.yaml` — config & guardrails
- `q4_audit.json` — no‑signalling and guardrail checks

A convenience plot is produced at `q4_S_vs_g.png`.

## Design (brief)
- **Source tie:** For each setting pair (a,b), draw λ∼Unif[0,1). With prob p_same=(1+E⋆)/2 choose tie set “same” {(+,+),(−,−)}, else “different” {(+,−),(−,+)}. Here E⋆ = ±c with c=1/√2 in `--mode tsirelson` (or c=1/2 in `--mode flat`).
- **Left gate:** Draw u∼Unif[0,1). Pass iff u≥g. If pass: PF/Born selects uniformly inside the 2‑outcome tie. If fail: both wings output independent fair ±1 (no tie). No postselection.
- **Metrics:** E_ab=⟨A·B⟩, S=|E00+E01+E10−E11|; no‑signalling audit checks that local marginals are independent of the remote setting.
- **Expected scaling:** E_ab(g)≈(1−g)E⋆_ab and S(g)≈(1−g)·2√2 (tsirelson).

## License
MIT
